# Workflow

## Работа над задачей

> Ниже представлен алгоритм, рекомендуемый для большинства задач.

1. Ознакомится с описанием, задать интересующие вопросы в трекере, проверить статусы готовности по смежным проектам.
2. Переводим статус задачи в состояние "В работе".
3. Создаем ветку от ветки dev c названием: [task-id]-task-name или просто [task-id], примеры: TRAVELFRONT-1234, TRAVELFRONT-1234-remove-hotelname.
4. Названия коммитов (отражающие суть коммита) -- на ваше усмотрение.
5. После завершения работы над задачей создаем PR в dev. Название берем из тикета, пример: "TRAVELFRONT-2341: Ошибка в выдаче на все дни". task-id нужен для Ревьюшницы. Ревьюшница автоматически добавит человека на ревью.
6. Проверяем статусы прохождения тестов и линтеров.
7. Управляем состоянием ревью комментариями к PR (`/add user`, `/start`, `/ping`, `/fixed`, `/stop`, `/restart`);
8. Переводим статус задачи в состояние "Ревью" по команде `/start` или вручную в трекере.
9. После успешного прохождения ревью тикет автоматически переводится в статус "Готово к тестированию". Если этого не произошло, то переводим тикет вручную.
10. Проверить, есть ли ответственный QA-инженер, по возможности описать примерную последовательность при тестировании.
11. QA-инженер должен перевести статус задачи в состояние "Тестируется" и провести тестирование функциональности, ветка с PR должна расскатится на специальный стенд на travel-ui.
12. При успешном прохождении тестирования перевести статус задачи в состояние "Протестировано", при наличии багов или переоткрыть или написать в комментарии, если правки небольшие.
13. Выполняем squash & merge PR в dev (удаляем большой description из оригинальных коммитов). Убедитесь, что сообщение для результирующего коммита соответствует названию PR (если коммитов было несколько - в сообщение попадает название PR, если коммит один - сообщение коммита). Ветка удалится автоматически.

## PR labels

Для того чтобы понимать статус задачи беглым просмотром по списку пул-реквестов, предлагается использовать дополнительные лейблы. Сделано на основе опыта команды Яндекс.Облако.

### Тип и приоритет задачи:

-   `Service: name` - указывает сервис, который затрагивался в PR. Может быть несколько лейблов данного типа на одном PR. Например, trains, avia, hotels, account, infrastructure, all.

### Статус ревью:

-   `review needed` - указывает, что PR можно смотреть.
-   `changes requested` - указывает, что PR требует правок от автора.
-   `review completed` - PR прошел ревью.

### Для ревью которые approved:

-   `Merge: hold` - указывает, что PR по какой-то причине еще нельзя мержить (например, он заблокирован выкаткой апи).

### Когда задача готова:

Задачу со статусом `Review: approved` и задачей в статусе протестировано - можно мержить.
