/* eslint-disable @typescript-eslint/naming-convention */

declare namespace Hermione {
    interface TestDefinitionCallbackCtx {
        /**
         * Наша доработка
         * Сами патчим это значение в hermione-global-hook
         */
        retryCount: number;
    }
}

declare namespace WebdriverIO {
    interface Browser {
        /**
         * Наши доработки добавленные через commands
         */
        switchToNextTab(): Promise<void>;
        login(login: string, password: string): Promise<void>;
        getValue(selector: string): Promise<string>;
        getBrowserName(): Promise<'firefox' | 'chrome' | null>;

        /**
         * Старые методы из webdriver 4
         */
        waitForExist(
            selector: string,
            ms?: number,
            reverse?: boolean,
        ): Promise<void>;
        waitForVisible(
            selector: string,
            ms?: number,
            reverse?: boolean,
        ): Promise<void>;
        scroll(
            selector: string,
            xOffset?: number,
            yOffset?: number,
        ): Promise<void>;
        isVisible(selector: string): Promise<boolean>;
        elementIdElement(
            elementId: string,
            selector: string,
        ): Promise<WebDriverElement>;
        getCssProperty(
            selector: string,
            cssProperty: string,
        ): Promise<IWDIOCssProperty>;
        setCookie(param: {name: string; value: string}): Promise<void>;
        frame(selector: string | null): Promise<void>;
        frameParent(): Promise<void>;
        isExisting(selector: string): Promise<boolean>;
        windowHandleSize(options: {
            width: number;
            height: number;
        }): Promise<void>;
        getCurrentTabId(): Promise<string>;
        getTabIds(): Promise<string[]>;
        switchTab(id: string): Promise<void>;

        /**
         * Настройки для браузера
         */
        requestedCapabilities: {
            'goog:chromeOptions': {mobileEmulation: unknown};
        };
    }
}

declare type WebDriverElement = any;

declare interface IWDIOCssProperty {
    property: string;
    value: number | string;
    parsed: object;
}

interface IComponent {
    path: string[];
    qa: string;
}

interface IObjectQAValue {
    /**
     * Ключ элемента в списке
     */
    key?: string | number;
    /**
     * qa родителя
     */
    parent?: string | IComponent;
    /**
     * qa текущего элемента
     */
    current?: string | null;
    /**
     * вложенность элемента в DOM дереве
     */
    path?: string[];
}

declare type QA = string | IObjectQAValue;

declare type NestedQA = string | string[];
