## commands

Это способ расширить интерфейс `webdriver` для часто переиспользуемых действий в интерфейсе. Например, подождать, пока контрол появится, прежде чем на него кликнуть.

create-e2e-app поставляется с небольшим набором команд, которые будут полезны для разных сценариев. Кроме того, можно легко добавить проектно-специфичные команды.

### Команды из lib

-   [login](lib/docs/login.md)

### Утилиты из lib

-   [qa](lib/docs/qa.md)

### Написание проектных команд

Положите проектно-специфичные команды в папку `./commands/project`. Чтобы эти команды были подключены в вебдрайвер, необходимо экспортировать метод, принимающий на вход объект браузера, который подключит команду.

**Пример**

```js
module.exports = browser => {
    /**
     * this - ссылка на объект browser
     *
     * @name browser.p_commandName
     * @returns {Browser}
     */
    browser.addCommand('p_commandName', function () {
        console.log('p_commandName...');

        // this - ссылка на объект browser
        return this;
    });
};
```
