export default function (browser: WebdriverIO.Browser): void {
    browser.addCommand('switchToNextTab', async () => {
        const currentTabId = await browser.getCurrentTabId();
        let ids = await browser.getTabIds();
        const nextTabPosition = ids.indexOf(currentTabId) + 1;

        if (nextTabPosition >= ids.length) {
            // Если в списке табов не появился новый таб - даём немного времени чтоб это произошло
            await browser.pause(500);
            ids = await browser.getTabIds();
        }

        await browser.switchTab(ids[nextTabPosition]);
    });
}
