/* DO NOT EDIT THIS FILE */
const CHROME = 'chrome';
const FIREFOX = 'firefox';
const EDGE = 'edge';
const IE = 'ie';
const YANDEX = 'yandex';
const OPERA = 'opera';

// Supported browser version can be found at https://selenium.yandex-team.ru/#quota/selenium
const DESKTOP_BROWSERS = {
    [CHROME]: (browserVersion = '77.0') => ({
        browserName: 'chrome',
        browserVersion,
    }),
    [FIREFOX]: (browserVersion = '69.0') => ({
        browserName: 'firefox',
        // We use internal certificates, which require to be installed additionally, ignore warnings
        acceptInsecureCerts: true,
        browserVersion,
    }),
    // Templates for Edge support
    // [EDGE]: (version = '16.1') => ({
    //     browserName: 'MicrosoftEdge',
    //     version
    // }),
    [OPERA]: (browserVersion = '58.0') => ({
        browserName: 'opera',
        browserVersion,
    }),
    [YANDEX]: (browserVersion = '19.4.0.1354') => ({
        browserName: 'chrome',
        browserVersion,
    }),
};

const TOUCH_BROWSERS = {
    chrome_android_phone: () => {
        return {
            ...DESKTOP_BROWSERS.chrome(),
            'goog:chromeOptions': {
                mobileEmulation: {
                    deviceMetrics: {
                        width: 360,
                        height: 640,
                        pixelRatio: 2.0,
                    },
                    userAgent: [
                        'Mozilla/5.0',
                        '(Linux; Android 5.0; Nexus 6 Build/LRX21D)',
                        'AppleWebKit/537.36',
                        '(KHTML, like Gecko)',
                        'Version/4.0',
                        'Chrome/77.0.0.0 Mobile',
                        'Safari/537.36',
                    ].join(' '),
                },
            },
        };
    },
    chrome_ios_phone: () => {
        return {
            ...DESKTOP_BROWSERS.chrome(),
            'goog:chromeOptions': {
                mobileEmulation: {
                    deviceMetrics: {
                        width: 320,
                        height: 568,
                        pixelRatio: 2.0,
                    },
                    userAgent: [
                        'Mozilla/5.0',
                        '(iPhone; CPU iPhone OS 9_1 like Mac OS X)',
                        'AppleWebKit/601.1.46',
                        '(KHTML, like Gecko)',
                        'Version/9.0',
                        'Mobile/13B143',
                        'Safari/601.1',
                    ].join(' '),
                },
            },
        };
    },
    chrome_ios_tablet: () => {
        return {
            ...DESKTOP_BROWSERS.chrome(),
            'goog:chromeOptions': {
                mobileEmulation: {
                    deviceMetrics: {
                        width: 1024,
                        height: 768,
                        pixelRatio: 2.0,
                    },
                    userAgent: [
                        'Mozilla/5.0',
                        '(iPad; CPU OS 10_2_1 like Mac OS X)',
                        'AppleWebKit/602.4.6',
                        '(KHTML, like Gecko)',
                        'Version/10.0',
                        'Mobile/14D27',
                        'Safari/602.1',
                    ].join(''),
                },
            },
        };
    },
};

const UNIMPLEMENTED = [IE, EDGE];

const COMMON_BROWSERS = {
    ...DESKTOP_BROWSERS,
    ...TOUCH_BROWSERS,
};

const SCREEN_SHOT_DELAY = 300;

function mapBrowserDescription({
    description,
    passportEnv,
    baseUrl,
    sessionsPerBrowser,
}) {
    const [id, version] = description.split(' ');

    if (UNIMPLEMENTED.includes(id)) {
        throw new Error(
            `e2e: browser "${id}" configuration is not implemented, please file a pull request.`,
        );
    }

    if (Object.prototype.hasOwnProperty.call(COMMON_BROWSERS, id)) {
        const [, prepareDesiredCapabilities] = Object.entries(
            COMMON_BROWSERS,
        ).find(([browserId]) => browserId === id);

        if (process.env.E2E_VERBOSE) {
            console.log(
                `e2e: adding browser "${description}" -\n parsed id "${id}" and version "${version}".`,
            );
        }

        return {
            [description]: {
                desiredCapabilities: prepareDesiredCapabilities(version),
                sessionsPerBrowser,
                compositeImage: true,
                screenshotDelay: SCREEN_SHOT_DELAY,
                windowSize: {
                    width: 1600,
                    height: 768,
                },
                meta: {passportEnv, baseUrl},
                ...(process.env.E2E_ENV === 'standalone'
                    ? {automationProtocol: 'devtools'}
                    : {}),
            },
        };
    }

    throw new Error(`e2e: unknown browser id "${id}".`);
}

function mapBrowserDescriptions({
    descriptions,
    passportEnv,
    baseUrl,
    sessionsPerBrowser,
}) {
    return descriptions.reduce(
        (aggr, description) => ({
            ...aggr,
            ...mapBrowserDescription({
                description,
                passportEnv,
                baseUrl,
                sessionsPerBrowser,
            }),
        }),
        {},
    );
}

const common = Object.keys(COMMON_BROWSERS);
const desktop = Object.keys(DESKTOP_BROWSERS);
const touch = Object.keys(TOUCH_BROWSERS);

/**
 * // TODO debug
 * There are certain problems when adding browser solely as "browser" to hermione config.
 *
 * If version is not provided in description - default version is appended
 * "firefox" => "firefox 67.0"
 * "firefox 47.0" => "firefox 47.0"
 * @param descriptions
 * @returns {*}
 */
function mapDefaultBrowserVersions(descriptions) {
    return descriptions.map(description => {
        const [id, version] = description.split(' ');

        if (UNIMPLEMENTED.includes(id)) {
            throw new Error(
                `e2e: browser "${id}" configuration is not implemented, please file a pull request.`,
            );
        }

        if (Object.prototype.hasOwnProperty.call(COMMON_BROWSERS, id)) {
            const prepareDesiredCapabilities = COMMON_BROWSERS[String(id)];

            const desiredCapabilities = prepareDesiredCapabilities(version);

            return `${id} ${desiredCapabilities.browserVersion}`;
        }

        throw new Error(`e2e: unknown browser id "${id}".`);
    });
}

const FIREFOX_POLYFILLS = [
    'moveTo',
    'buttonUp',
    'buttonDown',
    'buttonPress',
    'getValue',
    'getAttribute',
    'timeouts',
];

function prepareFirefoxWebDriverPolyfills(env, descriptions) {
    return descriptions.reduce((aggr, description) => {
        const [id] = description.split(' ');

        if (id === FIREFOX && env !== 'standalone') {
            return {
                ...aggr,
                [description]: FIREFOX_POLYFILLS,
            };
        }

        return aggr;
    }, {});
}

module.exports = {
    common,
    desktop,
    touch,
    mapBrowserDescriptions,
    mapDefaultBrowserVersions,
    prepareFirefoxWebDriverPolyfills,
};
