/* DO NOT EDIT THIS FILE */
const get = require('lodash').get;

function getStaticValue(config, name, defaultValue) {
    const configValue = get(config, name);

    if (
        typeof defaultValue === 'undefined' &&
        typeof configValue === 'undefined'
    ) {
        throw new Error(
            `e2e: configuration failed, no value provided for parameter "${name}"`,
        );
    }

    if (typeof configValue !== 'undefined') {
        return configValue;
    }

    return defaultValue;
}

function safeGetValue(object, key) {
    const [, value] =
        Object.entries(object).find(([currentKey]) => currentKey === key) || [];

    return value;
}

function getEnvOnlyValue(envName) {
    const envValue = safeGetValue(process.env, envName);

    if (typeof envValue === 'undefined') {
        throw new Error(
            `e2e: configuration failed, no value provided for env variable "${envName}"`,
        );
    }

    return envValue;
}

function getValue(envName, config, name, defaultValue) {
    const envValue = safeGetValue(process.env, envName);

    if (typeof envValue !== 'undefined') {
        return envValue;
    }

    return getStaticValue(config, name, defaultValue);
}

module.exports = {getValue, getStaticValue, getEnvOnlyValue};
