import {passengers} from 'suites/account';

import {RU_GEO_ID} from 'helpers/constants/document';

import {TFieldParams} from 'helpers/project/common/form/formFields';

const {citizenship, type} = passengers.qa.addPassenger;

export default [
    {
        id: 'passenger-lastName',
        type: 'text',
        value: 'Иванов',
    },
    {
        id: 'passenger-firstName',
        type: 'text',
        value: 'Иван',
    },
    {
        id: 'passenger-middleName',
        type: 'text',
        value: 'Иванович',
    },
    {
        id: 'passenger-birthDate',
        type: 'date',
        value: '01.01.1970',
    },
    {
        id: 'passenger-gender',
        type: 'radiobutton',
        value: 'М',
    },
    {
        id: 'passenger-citizenship',
        type: 'select',
        config: {
            triggerQa: citizenship.button,
        },
        value: RU_GEO_ID,
        compareValue: 'Россия',
    },
    {
        id: 'passenger-type',
        type: 'select',
        config: {
            triggerQa: type.button,
        },
        value: 'ru_national_passport',
        compareValue: 'Паспорт гражданина РФ',
    },
    {
        id: 'passenger-number',
        type: 'text',
        value: '6505654321',
    },
] as TFieldParams[];
