export interface IAviaTestContextParams {
    /**
     *  Результат проверки доступности варианта при редиректе на BoY
     */
    checkAvailabilityOnRedirOutcome:
        | 'CAOR_UNKNOWN'
        | 'CAOR_SUCCESS'
        | 'CAOR_PRICE_CHANGED'
        | 'CAOR_NOT_AVAILABLE';
    /**
     * Результат проверки доступности варианта перед созданием заказа
     */
    checkAvailabilityBeforeBookingOutcome:
        | 'CAO_UNKNOWN'
        | 'CAO_SUCCESS'
        | 'CAO_PRICE_CHANGED';
    /**
     * Результат токенизации карты
     */
    tokenizationOutcome: 'TO_UNKNOWN' | 'TO_SUCCESS' | 'TO_FAILURE';
    /**
     * Результат подтверждения бронирования заказа
     */
    confirmationOutcome:
        | 'CO_UNKNOWN'
        | 'CO_SUCCESS'
        | 'CO_PAYMENT_FAILED'
        | 'CO_VARIANT_NOT_AVIALABLE'
        | 'CO_PRICE_CHANGED';
    /**
     * Тип MQ события, присылаемого аэрофлотом о статусе заказа
     */
    mqEventOutcome:
        | 'MEO_UNKNOWN'
        | 'MEO_NO_EVENT'
        | 'MEO_SUCCESS'
        | 'MEO_NOT_PAID';
}

export interface IAviaTestContextAnswer {
    token: string;
    paymentToken: string;
}

export interface IAviaTestContextUrlParams {
    variantTestContext: string;
    paymentTestContext?: string;
}
