import {Component} from 'components/Component';
import {Button} from 'components/Button';

export interface ITestAviaFlight {
    arrival: string;
    departure: string;
    flightNumber: string;
    carryOn: string | null;
    baggage: string | null;
}

export class AviaFlightInfo extends Component {
    readonly planeModel: Component;
    readonly flightNumber: Component;
    readonly arrival: Component;
    readonly departure: Component;
    readonly duration: Component;
    readonly fromCity: Component;
    readonly toCity: Component;
    readonly fromAirport: Component;
    readonly toAirport: Component;
    readonly fareTermsButton: Button;
    readonly carryOn: Component;
    readonly baggage: Component;

    constructor(
        browser: WebdriverIO.Browser,
        qa: QA = 'avia-booking-flight-info',
    ) {
        super(browser, qa);

        this.planeModel = new Component(this.browser, {
            parent: this.qa,
            current: 'planeModel',
        });

        this.flightNumber = new Component(this.browser, {
            parent: this.qa,
            current: 'flightNumber',
        });

        this.departure = new Component(this.browser, {
            parent: this.qa,
            current: 'departure',
        });

        this.arrival = new Component(this.browser, {
            parent: this.qa,
            current: 'arrival',
        });

        this.duration = new Component(this.browser, {
            parent: this.qa,
            current: 'duration',
        });

        this.fromCity = new Component(this.browser, {
            parent: this.qa,
            current: 'fromCity',
        });

        this.toCity = new Component(this.browser, {
            parent: this.qa,
            current: 'toCity',
        });

        this.fromAirport = new Component(this.browser, {
            parent: this.qa,
            current: 'fromAirport',
        });

        this.toAirport = new Component(this.browser, {
            parent: this.qa,
            current: 'toAirport',
        });

        this.fareTermsButton = new Button(browser, {
            parent: this.qa,
            current: 'fareTermsButton',
        });

        this.carryOn = new Component(browser, {
            parent: this.qa,
            current: 'carry-on',
        });

        this.baggage = new Component(browser, {
            parent: this.qa,
            current: 'baggage',
        });
    }

    async getCarryOn(): Promise<string | null> {
        try {
            return this.carryOn.getText();
        } catch (e) {
            return null;
        }
    }

    async getBaggage(): Promise<string | null> {
        try {
            return this.baggage.getText();
        } catch (e) {
            return null;
        }
    }

    async getFlightData(): Promise<ITestAviaFlight> {
        return {
            arrival: await this.arrival.getText(),
            departure: await this.departure.getText(),
            flightNumber: await this.flightNumber.getText(),
            carryOn: await this.getCarryOn(),
            baggage: await this.getBaggage(),
        };
    }
}
