import {MINUTE} from 'helpers/constants/dates';

import {TestBookingOrderPNR} from 'helpers/project/avia/pages/AccountOrderPage/components/TestBookingOrderPNR';
import {TestBookingOrderUserContacts} from 'helpers/project/avia/pages/AccountOrderPage/components/TestBookingOrderUserContacts';
import TestTariffsModal from 'helpers/project/avia/components/TestTariffsModal/TestTariffsModal';

import {TestPrice} from 'components/TestPrice';
import {Component} from 'components/Component';
import {ComponentArray} from 'components/ComponentArray';
import {AviaFlightInfo} from '../../components/FlightInfo';
import {AviaBookingTravellerList} from './components/TravelerList';

export class AccountOrderPage extends Component {
    pnr: TestBookingOrderPNR;
    travellerList: AviaBookingTravellerList;
    flightInfo: ComponentArray<AviaFlightInfo>;
    price: TestPrice;
    contacts: TestBookingOrderUserContacts;
    tariffsModal: TestTariffsModal;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'aviaAccountOrderPage') {
        super(browser, qa);

        this.pnr = new TestBookingOrderPNR(browser, {
            parent: this.qa,
            current: 'pnr',
        });

        this.travellerList = new AviaBookingTravellerList(browser, {
            parent: this.qa,
            current: 'travellerList',
        });

        this.flightInfo = new ComponentArray(
            browser,
            {
                parent: this.qa,
                current: 'flightInfo',
            },
            AviaFlightInfo,
        );

        this.price = new TestPrice(browser, {
            parent: this.qa,
            current: 'price',
        });

        this.contacts = new TestBookingOrderUserContacts(browser, {
            parent: this.qa,
            current: 'contacts',
        });

        this.tariffsModal = new TestTariffsModal(browser);
    }

    async waitForPageLoading(): Promise<void> {
        await this.waitForVisible(3 * MINUTE);
    }

    async getOrderData() {
        const passengers = await this.travellerList.getPassengersData();
        const flight = await this.flightInfo.map(item => item.getFlightData());

        return {
            passengers,
            flight,
        };
    }

    async getOrderPrice(): Promise<string> {
        return this.travellerList.price.getText();
    }
}
