import {Component} from 'components/Component';
import {ComponentArray} from 'components/ComponentArray';
import {TestPrice} from 'components/TestPrice';

import {AviaBookingTraveller} from './BookingTraveller';

export class AviaBookingTravellerList extends Component {
    travellers: ComponentArray<AviaBookingTraveller>;
    price: TestPrice;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.travellers = new ComponentArray(
            browser,
            {
                parent: this.qa,
                current: 'traveller',
            },
            AviaBookingTraveller,
        );

        this.price = new TestPrice(browser, {
            parent: this.qa,
            current: 'price',
        });
    }

    async getPassengersData(): Promise<
        {
            name: string;
            document: string;
            birthDate: string;
        }[]
    > {
        return this.travellers.map(async traveller => ({
            name: await traveller.fullName.getText(),
            document: await traveller.fullDocument.getText(),
            birthDate: await traveller.birthDate.getText(),
        }));
    }
}
