import {ITestFormContacts} from 'helpers/project/common/components/TestBookingContactsForm/types';

import {IAviaPassenger} from 'helpers/project/avia/pages/CreateOrderPage/passengers';
import TestTariffsModal from 'helpers/project/avia/components/TestTariffsModal/TestTariffsModal';

import {Page} from 'components/Page';
import {Component} from 'components/Component';
import {AviaFlightInfo} from '../../components/FlightInfo';
import {AviaBookingForm} from './components/BookingForm';
import {AviaBookingErrorModal} from './components/ErrorModal';
import {AviaBookingPriceInfo} from './components/PriceInfo';
import {AviaBookingBanner} from './components/Banner';
import {AviaBookingBreadcrumbs} from './components/Breadcrumbs';
import {AviaBookingTariffs} from './components/Tariffs';
import {ComponentArray} from 'components/ComponentArray';

export class AviaCreateOrderPage extends Page {
    readonly banner: AviaBookingBanner;
    readonly form: AviaBookingForm;
    readonly flightInfo: ComponentArray<AviaFlightInfo>;
    readonly modalError: AviaBookingErrorModal;
    readonly priceInfo: AviaBookingPriceInfo;
    readonly breadcrumbs: AviaBookingBreadcrumbs;
    readonly tariffs: AviaBookingTariffs;
    readonly submitButton: Component;
    tariffsModal: TestTariffsModal;

    constructor(
        browser: WebdriverIO.Browser,
        qa = 'avia-booking-create-order-page',
    ) {
        super(browser, qa);

        this.banner = new AviaBookingBanner(browser);
        this.form = new AviaBookingForm(browser, {
            parent: this.qa,
            current: 'form',
        });
        this.flightInfo = new ComponentArray<AviaFlightInfo>(
            browser,
            {
                parent: this.qa,
                current: 'flightInfo',
            },
            AviaFlightInfo,
        );
        this.tariffsModal = new TestTariffsModal(browser);
        this.modalError = new AviaBookingErrorModal(browser);
        this.priceInfo = new AviaBookingPriceInfo(browser, {
            parent: this.qa,
            current: 'price-info',
        });
        this.breadcrumbs = new AviaBookingBreadcrumbs(browser, {
            parent: this.qa,
            current: 'breadcrumbs',
        });
        this.tariffs = new AviaBookingTariffs(browser, {
            parent: this.qa,
            current: 'tariffs',
        });
        this.submitButton = new Component(browser, {
            parent: this.qa,
            current: 'submit',
        });
    }

    async waitForPageLoading(timeout = 30000): Promise<void> {
        await this.waitForVisible(timeout);
    }

    async skipModals(): Promise<void> {
        await this.modalError.hide();
    }

    // Если показалась ошибка/предупреждение - пытаемся её скрыть
    // т.к. она перекрывает остальные элементы интерфейса
    async waitPageReadyForInteraction(timeout = 45000): Promise<void> {
        await this.waitForPageLoading(timeout);
        await this.skipModals();
    }

    async getOrderPrice(): Promise<string> {
        return this.priceInfo.getPrice();
    }

    async fillBookingForm(
        passengers: IAviaPassenger[],
        contacts: ITestFormContacts,
    ): Promise<void> {
        await this.form.fillForm(passengers, contacts);
    }

    async submitForm(): Promise<void> {
        await this.submitButton.click();
    }

    async goToPayment(): Promise<void> {
        await this.submitForm();
    }
}
