import {ITestFormContacts} from 'components/TestBookingContactsForm/types';

import {ComponentArray} from 'helpers/project/common/components';

import {Component} from 'components/Component';
import {TestBookingPassengerForm} from 'components/TestBookingPassengerForm/TestBookingPassengerForm';
import {TestBookingContactsForm} from 'components/TestBookingContactsForm/TestBookingContactsForm';

import {EAviaPassengerType, IAviaPassenger} from '../passengers';

export class AviaBookingForm extends Component {
    readonly contacts: TestBookingContactsForm;

    readonly passengers: ComponentArray<TestBookingPassengerForm>;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'avia-booking-form') {
        super(browser, qa);

        this.contacts = new TestBookingContactsForm(browser, {
            parent: this.qa,
            current: 'contacts',
        });
        this.passengers = new ComponentArray(
            browser,
            {parent: this.qa, current: 'passengers'},
            TestBookingPassengerForm,
        );
    }

    async fillPassengersForm(passengers: IAviaPassenger[]): Promise<void> {
        const counter: Record<EAviaPassengerType, number> = {
            adult: 0,
            child: 0,
            infant: 0,
        };

        for (let i = 0; i < passengers.length; i++) {
            const passenger = passengers[i];
            const {type} = passenger;
            const passengerForm = new TestBookingPassengerForm(this.browser, {
                parent: this.qa,
                current: 'passengers',
                key: `${type}-${counter[type]}`,
            });

            await passengerForm.fill(passenger, {hasPatronymic: true});
            counter[type]++;
        }
    }

    async fillPassengersFormWithIntent(
        passengers: IAviaPassenger[],
    ): Promise<void> {
        const counter: Record<EAviaPassengerType, number> = {
            adult: 0,
            child: 0,
            infant: 0,
        };

        for (let i = 0; i < passengers.length; i++) {
            const passenger = passengers[i];
            const {type} = passenger;

            const passengerForm = new TestBookingPassengerForm(this.browser, {
                parent: this.qa,
                current: 'passengers',
                key: `${type}-${counter[type]}`,
            });

            await passengerForm.fillWithIntent();
            counter[type]++;
        }
    }

    async fillContactsForm(contacts: ITestFormContacts): Promise<void> {
        await this.contacts.fill(contacts);
    }

    async fillForm(
        passengers: IAviaPassenger[],
        contacts: ITestFormContacts,
    ): Promise<void> {
        await this.fillPassengersForm(passengers);
        await this.fillContactsForm(contacts);
    }
}
