import {Component} from 'components/Component';
import {Button} from 'components/Button';

export class AviaBookingErrorModal extends Component {
    async hide(): Promise<void> {
        if (await this.isVisible(10000)) {
            try {
                const modal = await this.getElementQA();
                const actionButton = await modal.get('.button2_theme_action');

                await actionButton?.click();
            } catch (e) {}
        }
    }
}

export class AviaBookingPriceChangedErrorModal extends AviaBookingErrorModal {
    private readonly newPrice: Component;
    private readonly closeModal: Button;

    constructor(browser: WebdriverIO.Browser) {
        super(browser, {
            parent: 'aviaBookingModalError',
            current: 'PriceChanged',
        });

        this.newPrice = new Component(browser, {
            path: [this.qa],
            current: 'price',
        });

        this.closeModal = new Button(browser, {
            parent: this.qa,
            current: 'primaryAction',
        });
    }

    getNewPrice(): Promise<string> {
        return this.newPrice.getText();
    }

    async close(): Promise<void> {
        await this.closeModal.click();
    }
}
