import {Component} from 'components/Component';

export class AviaBookingPriceInfo extends Component {
    readonly totalPrice: Component;
    readonly oldPrice: Component;
    readonly updatedPriceAlert: Component;

    constructor(
        browser: WebdriverIO.Browser,
        qa: QA = 'avia-booking-price-info',
    ) {
        super(browser, qa);

        this.totalPrice = new Component(browser, {
            parent: this.qa,
            current: 'total-price',
        });

        this.oldPrice = new Component(browser, {
            parent: this.qa,
            current: 'oldPrice',
        });

        this.updatedPriceAlert = new Component(browser, {
            parent: this.qa,
            current: 'updatedPriceAlert',
        });
    }

    async getPrice(): Promise<string> {
        return this.totalPrice.getText();
    }

    async getOldPrice(): Promise<string> {
        return this.oldPrice.getText();
    }

    async getAlertMessage(): Promise<string> {
        return this.updatedPriceAlert.getText();
    }
}
