import {
    ETestDocumentType,
    ETestFieldName,
    ETestGender,
    ITestFormDocument,
} from 'components/TestBookingPassengerForm/types';

import {getDocumentName} from './documents';

export enum EAviaPassengerType {
    adult = 'adult',
    child = 'child',
    infant = 'infant',
}

export interface IAviaPassenger extends ITestFormDocument {
    type: EAviaPassengerType;
}

export const ADULT_MAN_WITH_PASSPORT: IAviaPassenger = {
    type: EAviaPassengerType.adult,
    [ETestFieldName.lastName]: 'PRUDININ',
    [ETestFieldName.firstName]: 'ARISTARKH',
    [ETestFieldName.patronymicName]: 'IVANOVICH',
    [ETestFieldName.birthdate]: '12.12.1980',
    [ETestFieldName.sex]: ETestGender.MALE,
    [ETestFieldName.documentType]: ETestDocumentType.RU_NATIONAL_PASSPORT,
    [ETestFieldName.documentNumber]: '5502111111',
};

export const ADULT_WOMAN_WITH_PASSPORT: IAviaPassenger = {
    type: EAviaPassengerType.adult,
    [ETestFieldName.lastName]: 'PRUDININA',
    [ETestFieldName.firstName]: 'ANNA',
    [ETestFieldName.patronymicName]: 'KIRILLOVNA',
    [ETestFieldName.birthdate]: '04.09.1983',
    [ETestFieldName.sex]: ETestGender.FEMALE,
    [ETestFieldName.documentType]: ETestDocumentType.RU_NATIONAL_PASSPORT,
    [ETestFieldName.documentNumber]: '5502222222',
};

export const getPassengerDescription = (passenger: IAviaPassenger): string =>
    [
        [
            passenger[ETestFieldName.lastName],
            passenger[ETestFieldName.firstName],
            passenger[ETestFieldName.patronymicName],
        ].join(' '),
        [
            getDocumentName(passenger[ETestFieldName.documentType]),
            passenger[ETestFieldName.documentNumber],
        ].join(' '),
        passenger[ETestFieldName.birthdate],
    ].join(' ');
