import {
    AviaSearchForm,
    IAviaSearchFormParams,
} from 'helpers/project/avia/components/AviaSearchForm';
import {AviaPopularDirections} from 'helpers/project/avia/components/AviaPopularDirections';

import {IndexTabs} from 'components/IndexTabs';
import {Component} from 'components/Component';
import {AdFoxBanner} from 'components/AdFoxBanner';
import {TestHeader} from 'components/TestHeader';

export class AviaIndexPage extends Component {
    searchForm: AviaSearchForm;
    popularDirection: AviaPopularDirections;
    indexTabs: IndexTabs;
    adfoxBanner: AdFoxBanner;
    header: TestHeader;

    constructor(browser: WebdriverIO.Browser) {
        super(browser);

        this.searchForm = new AviaSearchForm(browser);

        this.popularDirection = new AviaPopularDirections(browser);

        this.indexTabs = new IndexTabs(browser);

        this.adfoxBanner = new AdFoxBanner(browser);

        this.header = new TestHeader(browser);
    }

    async search(params: IAviaSearchFormParams): Promise<void> {
        await this.searchForm.fill(params);
        await this.searchForm.submitForm();
    }

    async goIndexPage(): Promise<void> {
        await this.browser.url('/');
    }
}
