import {AviaFlightTimings} from 'helpers/project/avia/components/FlightTimings';

import {Component} from 'components/Component';

export class AviaOrderFlight extends Component {
    readonly companyTitle: Component;
    readonly planeNumber: Component;
    readonly timings: AviaFlightTimings;
    readonly fromCity: Component;
    readonly toCity: Component;
    readonly fromAirport: Component;
    readonly toAirport: Component;
    readonly fromAirportCode: Component;
    readonly toAirportCode: Component;
    readonly planeModel: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.companyTitle = new Component(browser, {
            parent: this.qa,
            current: 'companyTitle',
        });

        this.planeNumber = new Component(browser, {
            parent: this.qa,
            current: 'planeNumber',
        });

        this.timings = new AviaFlightTimings(browser, {
            parent: this.qa,
            current: 'timings',
        });

        this.fromCity = new Component(browser, {
            parent: this.qa,
            current: 'fromCity',
        });

        this.toCity = new Component(browser, {
            parent: this.qa,
            current: 'toCity',
        });

        this.fromAirport = new Component(browser, {
            parent: this.qa,
            current: 'fromAirport',
        });

        this.toAirport = new Component(browser, {
            parent: this.qa,
            current: 'toAirport',
        });

        this.fromAirportCode = new Component(browser, {
            parent: this.qa,
            current: 'fromAirportCode',
        });

        this.toAirportCode = new Component(browser, {
            parent: this.qa,
            current: 'toAirportCode',
        });

        this.planeModel = new Component(browser, {
            parent: this.qa,
            current: 'planeModel',
        });
    }
}
