import {AviaOrderShareBlock} from 'helpers/project/avia/pages/OrderPage/components/ShareBlock';

import {Component} from 'components/Component';

export class AviaOrderHeader extends Component {
    readonly backLink: Component;
    readonly shareBlock: AviaOrderShareBlock;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.backLink = new Component(browser, {
            parent: this.qa,
            current: 'backLink',
        });

        this.shareBlock = new AviaOrderShareBlock(browser, {
            parent: this.qa,
            current: 'shareBlock',
        });
    }
}
