import TestAviaTariffSelector from 'helpers/project/avia/pages/SearchResultsPage/components/TestAviaResultVariant/components/TestAviaDesktopResultVariant/components/TestAviaTariffSelector';
import TestAviaTariffSelectorPopup from 'helpers/project/avia/pages/SearchResultsPage/components/TestAviaResultVariant/components/TestAviaDesktopResultVariant/components/TestAviaTariffSelectorPopup';

import {Component} from 'components/Component';
import {ComponentArray} from 'components/ComponentArray';

import {AviaOrderOffer} from './Offer';
import {AviaOrderOffersTitle} from './OffersTitle';

export class AviaOrderOffers extends Component {
    readonly title: AviaOrderOffersTitle;
    readonly all: ComponentArray<AviaOrderOffer>;
    readonly tariffSelector: TestAviaTariffSelector;
    readonly tariffSelectorPopup: ComponentArray<TestAviaTariffSelectorPopup>;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'avia-order-offers') {
        super(browser, qa);

        this.title = new AviaOrderOffersTitle(browser, {
            parent: this.qa,
            current: 'title',
        });

        this.all = new ComponentArray(
            browser,
            {
                parent: this.qa,
                current: 'offer',
            },
            AviaOrderOffer,
        );

        this.tariffSelector = new TestAviaTariffSelector(browser, {
            parent: this.qa,
            current: 'tariffSelectorButton',
        });

        this.tariffSelectorPopup =
            new ComponentArray<TestAviaTariffSelectorPopup>(
                browser,
                {
                    parent: this.qa,
                    current: 'tariffSelectorPopup',
                },
                TestAviaTariffSelectorPopup,
            );
    }

    get company(): Promise<AviaOrderOffer> {
        return (async (): Promise<AviaOrderOffer> =>
            this.getOffer([
                {parent: this.qa, current: 'offer', key: 'cheapest-company'},
                {parent: this.qa, current: 'offer', key: 'company'},
            ]))();
    }

    get cheapest(): Promise<AviaOrderOffer> {
        return (async (): Promise<AviaOrderOffer> =>
            this.getOffer([
                {parent: this.qa, current: 'offer', key: 'cheapest-company'},
                {parent: this.qa, current: 'offer', key: 'cheapest'},
            ]))();
    }

    get allOffers(): Promise<AviaOrderOffer[]> {
        return this.all.items;
    }

    async isCorrectLogo(logo: string): Promise<boolean> {
        return this.all.some(async offer => {
            return (await offer.logo.getSrc())?.includes(logo) ?? false;
        });
    }

    private async getOffer(qas: QA[]): Promise<AviaOrderOffer> {
        return Promise.race(
            qas.map(async qa => {
                const offer = new AviaOrderOffer(this.browser, qa);

                await offer.isVisible();

                return offer;
            }),
        );
    }
}
