import {Component} from 'components/Component';

export class AviaOrderRouteTitle extends Component {
    readonly points: Component;
    readonly dates: Component;

    constructor(
        browser: WebdriverIO.Browser,
        qa: QA = 'avia-order-route-title',
    ) {
        super(browser, qa);

        this.points = new Component(browser, {
            parent: this.qa,
            current: 'points',
        });
        this.dates = new Component(browser, {
            parent: this.qa,
            current: 'dates',
        });
    }
}
