import {AviaOrderSocialLinks} from 'helpers/project/avia/pages/OrderPage/components/SocialLinks';

import {Component} from 'components/Component';

export class AviaOrderShareBlock extends Component {
    readonly link: Component;
    readonly copy: Component;
    readonly socialLinks: AviaOrderSocialLinks;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.link = new Component(browser, {
            parent: this.qa,
            current: 'input',
        });

        this.copy = new Component(browser, {
            parent: this.qa,
            current: 'input',
        });

        this.socialLinks = new AviaOrderSocialLinks(browser, {
            parent: this.qa,
            current: 'socialLinks',
        });
    }
}
