import {Loader} from 'helpers/project/common/components/Loader';
import {ITestCard} from 'helpers/project/common/TestTrustForm/card';
import {TestIframe} from 'helpers/project/common/components/TestIframe';
import {OldTestTrustForm} from 'helpers/project/common/TestTrustForm/OldTestTrustForm';

import {Component} from 'components/Component';

export class AviaPaymentOrderPage extends Component {
    readonly loader: Loader;
    private readonly iframe: TestIframe;
    private readonly trustForm: OldTestTrustForm;

    constructor(
        browser: WebdriverIO.Browser,
        qa = 'avia-booking-payment-frame',
    ) {
        super(browser);

        this.qa = qa;

        this.loader = new Loader(browser, {
            parent: 'aviaBookingLayout',
            current: 'loader',
        });

        this.trustForm = new OldTestTrustForm(browser);

        this.iframe = new TestIframe(browser, this.qa);
    }

    async waitForPageLoading(timeout = 30000): Promise<void> {
        await this.waitForVisible(timeout);
    }

    async pay(card: ITestCard): Promise<void> {
        await this.iframe.workInFrame(async () => {
            await this.trustForm.pay(card);
        });
    }
}
