import {ElementClass} from 'helpers/project/common/ElementClass/ElementClass';

import {Component} from 'components/Component';

export class Calendar extends Component {
    constructor(browser: WebdriverIO.Browser, qa: QA = 'calendar') {
        super(browser, qa);
    }

    async clickCalendarDate(date: string): Promise<void> {
        const day = await this.getCalendarDay(date);

        await day.click();
    }

    private getCalendarDaySelector(date: string): string {
        return this.prepareQaSelector(`${this.qa}-day-${date}`);
    }

    private async getCalendarDay(date: string): Promise<ElementClass> {
        return this.getElement(this.getCalendarDaySelector(date));
    }
}
