import {
    map,
    find,
    some,
    every,
    filter,
    findSeries,
    forEach,
    reduce,
} from 'p-iteration';

import {ElementClass} from 'helpers/project/common/ElementClass/ElementClass';

import {Component, IConstructable} from './Component';

export class ComponentArray<T extends Component = Component> extends Component {
    private readonly Ctor: IConstructable<T>;

    constructor(browser: WebdriverIO.Browser, qa: QA, Ctor: IConstructable<T>) {
        super(browser, qa);

        this.Ctor = Ctor;
    }

    get items(): Promise<T[]> {
        return (async (): Promise<T[]> => {
            return map(
                await this.getElementsEndingQA(`-${this.qa}`),
                async element =>
                    new this.Ctor(this.browser, {
                        path: this._parentPath,
                        current: await element.getAttribute('data-qa'),
                    }),
            );
        })();
    }

    async count(): Promise<number> {
        return (await this.items).length;
    }

    async at(index: number): Promise<T> {
        return (await this.items)[index];
    }

    async map<U>(
        callback: (
            currentValue: T,
            index: number,
            array: T[],
        ) => U | Promise<U>,
    ): Promise<U[]> {
        return map(await this.items, callback);
    }

    async find(
        callback: (
            currentValue: T,
            index: number,
            array: T[],
        ) => boolean | Promise<boolean>,
    ): Promise<T | undefined> {
        return find(await this.items, callback);
    }

    async some(
        callback: (
            currentValue: T,
            index: number,
            array: T[],
        ) => boolean | Promise<boolean>,
    ): Promise<boolean> {
        return some(await this.items, callback);
    }

    async every(
        callback: (
            currentValue: T,
            index: number,
            array: T[],
        ) => boolean | Promise<boolean>,
    ): Promise<boolean> {
        return every(await this.items, callback);
    }

    async filter(
        callback: (
            currentValue: T,
            index: number,
            array: T[],
        ) => boolean | Promise<boolean>,
    ): Promise<T[]> {
        return filter(await this.items, callback);
    }

    async findSeries(
        callback: (
            currentValue: T,
            index: number,
            array: T[],
        ) => boolean | Promise<boolean>,
    ): Promise<T | undefined> {
        return findSeries<T>(await this.items, callback);
    }

    async forEach(
        callBack: (
            currentValue: T,
            index: number,
            array: T[],
        ) => void | Promise<void>,
    ): Promise<void> {
        return forEach(await this.items, callBack);
    }

    async reduce<U>(
        callBack: (
            accumulator: U,
            currentValue: T,
            currentIndex: number,
            array: T[],
        ) => U | Promise<U>,
        initialValue?: U,
    ): Promise<U> {
        return reduce(await this.items, callBack, initialValue);
    }

    async first(): Promise<T> {
        return (await this.items)[0];
    }

    async last(): Promise<T> {
        const items = await this.items;

        return items[items.length - 1];
    }

    private getElementsEndingQA(
        qa: string,
        timeout?: number,
    ): Promise<ElementClass[]> {
        return this.getElements(
            this.prepareEndingQaSelector(qa || this.qa),
            timeout,
        );
    }
}
