import {ElementClass} from 'helpers/project/common/ElementClass/ElementClass';

import {SearchFormFieldModal} from './SearchFormFieldModal';
import {Calendar} from './Calendar';
import {DatePickerTrigger} from './DatePickerTrigger';
import {Component} from './Component';
import {retry} from '../retry';

export class DatePicker extends Component {
    startTrigger: DatePickerTrigger;
    endTrigger: DatePickerTrigger;

    modal: SearchFormFieldModal;
    calendar: Calendar;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.startTrigger = new DatePickerTrigger(browser, {
            parent: this.qa,
            current: 'start-trigger',
        });
        this.endTrigger = new DatePickerTrigger(browser, {
            parent: this.qa,
            current: 'end-trigger',
        });

        this.modal = new SearchFormFieldModal(this.browser);
        this.calendar = new Calendar(this.browser);
    }

    async selectStartDate(date: string): Promise<void> {
        const trigger = await this.startTrigger.getElementQA();

        await this.selectDate(trigger, date);
    }

    async selectEndDate(date: string): Promise<void> {
        const trigger = await this.endTrigger.getElementQA();

        await this.selectDate(trigger, date);
    }

    private async selectDate(
        trigger: ElementClass,
        date: string,
    ): Promise<void> {
        do {
            await trigger.click();
        } while (!(await this.calendar.isVisible()));

        await retry(async () => {
            //ждем анимацию
            await this.browser.pause(1000);

            await this.calendar.clickCalendarDate(date);
        })();
    }
}
