import {Component} from './Component';

interface IHeaderSearchInformationParams {
    date: string;
    direction: string;
    guests: string;
}

export class HeaderSearchInformation extends Component {
    direction: Component;
    date: Component;
    guests: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.direction = new Component(browser, {
            parent: this.qa,
            current: 'direction',
        });
        this.date = new Component(browser, {parent: this.qa, current: 'date'});
        this.guests = new Component(browser, {
            parent: this.qa,
            current: 'guests',
        });
    }

    async getSearchParams(): Promise<IHeaderSearchInformationParams> {
        const direction = await this.direction.getText();
        const date = await this.date.getText();
        const guests = await this.guests.getText();

        return {
            date,
            guests,
            direction,
        };
    }
}
