import {MINUTE} from 'helpers/constants/dates';

import {Component} from './Component';

export class Loader extends Component {
    private static timeout = MINUTE;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'loader') {
        super(browser, qa);
    }

    async waitUntilLoaded(timeout: number = Loader.timeout): Promise<void> {
        try {
            await this.waitForVisible(timeout);
        } catch (e) {
            return;
        }

        await this.waitForHidden(timeout);
    }
}
