import {Component} from './Component';

export class Recipe extends Component {
    title: Component;
    project: Component;
    from: Component;
    to: Component;
    price: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'recipe') {
        super(browser, qa);

        this.title = new Component(browser, {
            parent: this.qa,
            current: 'title',
        });
        this.project = new Component(browser, {
            parent: this.qa,
            current: 'project',
        });
        this.from = new Component(browser, {parent: this.qa, current: 'from'});
        this.to = new Component(browser, {parent: this.qa, current: 'to'});
        this.price = new Component(browser, {
            parent: this.qa,
            current: 'price',
        });
    }
}
