import {Component} from './Component';

export class SearchButtonGroup extends Component {
    private getButtonQA(value: string) {
        return `${this.qa}-${value}`;
    }

    private async getButton(value: string) {
        return this.getElementQA(this.getButtonQA(value));
    }

    public async clickByValue(value: string) {
        const button = await this.getButton(value);

        return button.click();
    }
}
