import {Button} from 'components/Button';

import {Component} from './Component';

export class SearchFormFieldModal extends Component {
    component: Component;
    footer: Component;
    cancel: Component;

    private readonly completeButton: Button;

    constructor(
        browser: WebdriverIO.Browser,
        qa: string = 'search-form-field-modal',
    ) {
        super(browser, qa);

        this.component = new Component(browser, {
            parent: this.qa,
            current: 'component',
        });

        this.footer = new Component(browser, {
            parent: this.qa,
            current: 'footer',
        });

        this.cancel = new Component(browser, {
            parent: this.qa,
            current: 'cancel',
        });

        this.completeButton = new Button(browser, `${qa}-button-complete`);
    }

    async clickCompleteButton(): Promise<void> {
        await this.completeButton.click();
    }
}
