import {Button} from 'components/Button';

import {Component} from './Component';

export class TravellersCount extends Component {
    readonly count: Component;
    readonly minusButton: Button;
    readonly plusButton: Button;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.count = new Component(browser, {
            parent: this.qa,
            current: 'value',
        });

        this.minusButton = new Button(browser, {
            parent: this.qa,
            current: 'minusButton',
        });
        this.plusButton = new Button(browser, {
            parent: this.qa,
            current: 'plusButton',
        });
    }

    async setCount(count: number | string): Promise<void> {
        const currentCount = await this.count.getText();

        const difference = Number(count) - Number(currentCount);

        const clickTargetQa =
            difference < 0
                ? await this.minusButton.getElementQA()
                : await this.plusButton.getElementQA();

        const timesToClick = Math.abs(difference);

        for (let i = 0; i < timesToClick; i++) {
            await clickTargetQa.click();
        }
    }
}
