import * as defaultTextField from './textField';
import * as defaultSelectField from './selectField';
import * as defaultRadioField from './radioField';
import * as defaultDateField from './dateField';

export type TFieldParams = {
    id: string;
    value: string;
    compareValue?: string;
} & (
    | {
          type: 'text' | 'date' | 'radiobutton';
      }
    | {type: 'select'; config: defaultSelectField.IFillSelectParams}
);

/** @deprecated - используйте компонентный подход */
export const fillInConstructor = ({
    textField = defaultTextField,
    selectField = defaultSelectField,
    radioField = defaultRadioField,
    dateField = defaultDateField,
} = {}) =>
    async function _fillIn(
        browser: WebdriverIO.Browser,
        fields: TFieldParams[],
        fieldIndex: number = 0,
    ): Promise<void | {completed: boolean}> {
        if (fieldIndex >= fields.length) {
            return {completed: true};
        }

        const field = fields[fieldIndex];

        if (field.type === 'text') {
            await textField.fillIn(browser, field.id, field.value);
        } else if (field.type === 'date') {
            await dateField.fillIn(browser, field.id, field.value);
        } else if (field.type === 'select') {
            await selectField.fillIn(
                browser,
                field.id,
                field.value,
                field.config,
            );
        } else if (field.type === 'radiobutton') {
            await radioField.fillIn(browser, field.id, field.value);
        } else {
            throw new Error(
                `formFields: unknown field type "${field.type}" supplied`,
            );
        }

        return _fillIn(browser, fields, fieldIndex + 1);
    };
