import {HeaderSearchInformation} from 'components/HeaderSearchInformation';
import {Component} from 'components/Component';

export class HotelsHeaderSearchInformation extends Component {
    searchInformation: HeaderSearchInformation;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.searchInformation = new HeaderSearchInformation(this.browser, {
            parent: this.qa,
            current: 'headerSearchInformation',
        });
    }

    async openSearchForm(): Promise<void> {
        await this.searchInformation.click();
    }
}
