import {sample, without} from 'lodash';

interface ITestHotelInfo {
    permalink: number;
    title: string;
    searchTitle: string;
    geoText: string;
}

export enum EHotelType {
    VEGA_IZMAILOVO = 'VEGA_IZMAILOVO',
    KOSMOS = 'KOSMOS',
    GORODOTEL = 'GORODOTEL',
    META_MOSKVA = 'META_MOSKVA',
}

const HOTELS_PERMALINKS: Record<EHotelType, ITestHotelInfo> = {
    [EHotelType.VEGA_IZMAILOVO]: {
        permalink: 1002445907,
        title: 'Вега Измайлово 4*',
        searchTitle: 'Вега Измайлово',
        geoText: '8,8 км до центра',
    },
    [EHotelType.KOSMOS]: {
        permalink: 1376154547,
        title: 'Космос 3*',
        searchTitle: 'Космос',
        geoText: '7,9 км до центра',
    },
    [EHotelType.GORODOTEL]: {
        permalink: 1776895989,
        title: 'ГородОтель',
        searchTitle: 'ГородОтель',
        geoText: '3 км до центра',
    },
    [EHotelType.META_MOSKVA]: {
        permalink: 107375353234,
        title: 'МетаМосква 3*',
        searchTitle: 'МетаМосква',
        geoText: '1,5 км до центра',
    },
};

const ALL_HOTELS = Object.values(EHotelType);

export function getRandomHotel(
    excludeHotels: EHotelType[] = [],
): ITestHotelInfo {
    const hotelsPool = without(ALL_HOTELS, ...excludeHotels);
    const selectedHotel = sample(hotelsPool) ?? hotelsPool[0];

    return HOTELS_PERMALINKS[selectedHotel];
}
