import {Moment} from 'moment';

import {HotelsSearchForm} from 'helpers/project/hotels/components/HotelsSearchForm';
import {TestHotelsCityPageSearchResults} from 'helpers/project/hotels/pages/HotelsCityPage/TestHotelsCityPageSearchResults';
import {TestCityPageHotelModal} from 'helpers/project/hotels/pages/HotelsCityPage/TestCityPageHotelModal';
import dateFormats from 'helpers/utilities/date/formats';

import {Component} from 'components/Component';

const HOTELS_QA_PREFIX = 'hotels';
const CITY_PAGE_QA_PREFIX = `${HOTELS_QA_PREFIX}-geoPage`;

export class HotelsCityPage extends Component {
    searchForm: HotelsSearchForm;
    cityPageBreadcrumps: Component;
    searchResults: TestHotelsCityPageSearchResults;
    hotelModal: TestCityPageHotelModal;

    constructor(browser: WebdriverIO.Browser) {
        super(browser);

        this.cityPageBreadcrumps = new Component(this.browser, {
            parent: CITY_PAGE_QA_PREFIX,
            current: 'breadcrumps',
        });

        this.searchForm = new HotelsSearchForm(this.browser);

        this.searchResults = new TestHotelsCityPageSearchResults(
            this.browser,
            this.qa,
        );

        this.hotelModal = new TestCityPageHotelModal(this.browser, {
            parent: 'geoRegionHotelSearchFormModal',
        });
    }

    async waitForLoadingFinished(): Promise<void> {
        return this.cityPageBreadcrumps.waitForVisible(25000);
    }

    async fillSearchParametersInHotelModalAndSubmit(
        checkinDate: Moment,
        checkoutDate: Moment,
        adults: number,
    ): Promise<void> {
        const modalSearchForm = this.hotelModal.searchForm;

        await modalSearchForm.fill({
            adults,
            checkinDate: checkinDate.format(dateFormats.ROBOT),
            checkoutDate: checkoutDate.format(dateFormats.ROBOT),
        });

        await modalSearchForm.submitForm();
    }
}
