import {HotelsPopularPlaces} from 'helpers/project/hotels/components/HotelsPopularPlaces';
import {HotelsSearchForm} from 'helpers/project/hotels/components/HotelsSearchForm';

import {Component} from 'components/Component';
import {AdFoxBanner} from 'components/AdFoxBanner';
import {IndexTabs} from 'components/IndexTabs';

export class HotelsIndexPage extends Component {
    searchForm: HotelsSearchForm;
    popularPlaces: HotelsPopularPlaces;
    adfoxBanner: AdFoxBanner;
    indexTabs: IndexTabs;

    constructor(browser: WebdriverIO.Browser) {
        super(browser);

        this.searchForm = new HotelsSearchForm(browser);

        this.popularPlaces = new HotelsPopularPlaces(browser);

        this.adfoxBanner = new AdFoxBanner(browser);

        this.indexTabs = new IndexTabs(browser);
    }
}
