/**
 * Swagger Тестового Контекста
 * https://api.travel-balancer-test.yandex.net/swagger-ui.html#/test-context-controller/getTokensUsingGET
 * (справа сверху в селекте выбрать "4. test")
 **/
export interface IBookOfferRequestParams {
    originalId: number;
    partnerId: 'PI_TRAVELLINE' | 'PI_BNOVO';
    /** Количество гостей в формете 'N-C1,C2,..', где N количество взрослых, C1,C2,.. - возраста детей */
    occupancy: number | string;
    forceAvailability: boolean;
    checkinDate: string;
    checkoutDate: string;
    cancellation:
        | 'CR_FULLY_REFUNDABLE'
        | 'CR_PARTIALLY_REFUNDABLE'
        | 'CR_NON_REFUNDABLE';
    pansionType: 'PT_BB';
    offerName: string;
    priceAmount: number;
    partiallyRefundRate?: number;
    getOfferOutcome: 'OO_SUCCESS' | 'OO_SOLD_OUT';
    createOrderOutcome: 'OO_SUCCESS' | 'OO_SOLD_OUT';
    hotelDataLookupOutcome: 'HO_MOCKED' | 'HO_REAL';
    reservationOutcome: 'RO_SUCCESS';
    confirmationOutcome: 'CO_SUCCESS' | 'CO_NOT_FOUND';
    refundOutcome: 'RF_SUCCESS' | 'RF_UNEXPECTED_PENALTY';
    priceMismatchRate: number;
}
