import {Button} from 'components/Button';
import {Component} from 'components/Component';
import {SearchSuggest} from 'components/SearchSuggest';
import {AdFoxBanner} from 'components/AdFoxBanner';
import {DatePicker} from 'components/DatePicker';

export class RailwaysSearchForm extends Component {
    fromSuggest: SearchSuggest;
    toSuggest: SearchSuggest;
    whenDatePicker: DatePicker;
    submitButton: Button;
    errorTooltip: Component;

    private adFox: AdFoxBanner;

    constructor(browser: WebdriverIO.Browser) {
        super(browser, 'railways-search-form');

        this.fromSuggest = new SearchSuggest(this.browser, {
            parent: this.qa,
            current: 'search-suggest-from',
        });
        this.toSuggest = new SearchSuggest(this.browser, {
            parent: this.qa,
            current: 'search-suggest-to',
        });

        this.whenDatePicker = new DatePicker(this.browser, {
            parent: this.qa,
            current: 'date-picker',
        });

        this.submitButton = new Button(this.browser, {
            parent: this.qa,
            current: 'submit',
        });

        this.adFox = new AdFoxBanner(this.browser);

        this.errorTooltip = new Component(this.browser, 'search-errorTooltip');
    }

    async fill({
        from,
        to,
        when,
    }: {
        from: string;
        to: string;
        when: string;
    }): Promise<void> {
        await this.adFox.disableEvents();

        await this.fromSuggest.setValue(from);
        await this.toSuggest.setValue(to);
        await this.whenDatePicker.selectStartDate(when);
        await this.adFox.enableEvents();
    }

    async submitForm(): Promise<void> {
        await this.submitButton.click();
    }
}
