import {TestOrderSummary} from 'helpers/project/trains/components/TestOrderSummary/TestOrderSummary';
import {TestTrainsOrderSteps} from 'helpers/project/trains/components/TestTrainsOrderSteps';

import {Component} from 'components/Component';
import {TestFooter} from 'components/TestFooter';

/**
 * Общие элементы на страницах заказа в ЖД
 */
export default class TrainsOrderPageLayout extends Component {
    orderSummary: TestOrderSummary;
    orderSteps: TestTrainsOrderSteps;
    footer: Component;

    constructor(browser: WebdriverIO.Browser, qa?: QA) {
        super(browser, qa);

        this.orderSummary = new TestOrderSummary(browser, 'pageOrderSummary');

        this.orderSteps = new TestTrainsOrderSteps(browser);

        this.footer = new TestFooter(browser);
    }

    async goNextStep(): Promise<void> {
        await this.orderSummary.orderButton.click();
    }
}
