/**
 * Функция проверяет, что номер у сегмента с поиска совпадает с номером сегмента на странице покупки.
 *
 * Если на странице поиска номер с двумя буквами,
 * например 100ЩЭ, то на странице выбора мест буква останется только одна, т.к. будет конкретный поезд.
 */
function isTrainsSearchAndOrderSegmentsNumbersEqual(
    searchSegmentNumber,
    orderSegmentNumber,
) {
    const {1: numberNumericPart, 2: numberAlphabeticPart} =
        searchSegmentNumber.match(/(\d*)([А-Я]*)/);

    return numberAlphabeticPart
        .split('')
        .some(char => `${numberNumericPart}${char}` === orderSegmentNumber);
}

exports.isTrainsSearchAndOrderSegmentsNumbersEqual =
    isTrainsSearchAndOrderSegmentsNumbersEqual;
