import {URL} from 'url';

import {TrainsPopularDirections} from 'helpers/project/trains/components/TrainsPopularDirections';
import {RailwaysSearchForm} from 'helpers/project/trains/components/RailwaysSearchForm';

import {Component} from 'components/Component';
import {AdFoxBanner} from 'components/AdFoxBanner';
import {IndexTabs} from 'components/IndexTabs';

export class TrainsIndexPage extends Component {
    searchForm: RailwaysSearchForm;
    popularDirection: TrainsPopularDirections;
    adfoxBanner: AdFoxBanner;
    indexTabs: IndexTabs;

    constructor(browser: WebdriverIO.Browser) {
        super(browser);

        this.searchForm = new RailwaysSearchForm(browser);

        this.popularDirection = new TrainsPopularDirections(browser);

        this.adfoxBanner = new AdFoxBanner(browser);

        this.indexTabs = new IndexTabs(browser);
    }

    async isOpened(): Promise<boolean> {
        const currentUrl = await this.browser.getUrl();
        const {pathname} = new URL(currentUrl);

        return pathname === '/trains/';
    }
}
