import moment from 'moment';

import dateFormats from './formats';
import {CHAR_MIDDLE_DASH} from '../strings/charCodes';

export default function humanizePeriod(
    start: string,
    end: string,
    short: boolean = false,
): string {
    const startMoment = moment(start);
    const endMoment = moment(end);

    const isAnotherYear = startMoment.isAfter(moment(), 'year');

    if (startMoment.isSame(endMoment, 'day')) {
        return startMoment.format(getFormatForDate(isAnotherYear));
    }

    const format = getFormatForInterval(isAnotherYear, short);

    if (startMoment.isSame(endMoment, 'month')) {
        return `${startMoment.date()} ${CHAR_MIDDLE_DASH} ${endMoment.format(
            format,
        )}`;
    }

    return `${startMoment.format(
        format,
    )} ${CHAR_MIDDLE_DASH} ${endMoment.format(format)}`;
}

function getFormatForDate(isAnotherYear: boolean): string {
    return isAnotherYear ? dateFormats.HUMAN_WITH_YEAR : dateFormats.HUMAN;
}

function getFormatForInterval(isAnotherYear: boolean, short: boolean): string {
    if (isAnotherYear) {
        return short
            ? dateFormats.HUMAN_SHORT_WITH_SHORT_YEAR
            : dateFormats.HUMAN_WITH_YEAR;
    }

    return short ? dateFormats.HUMAN_SHORT : dateFormats.HUMAN;
}
