import moment from 'moment';

import localesOverrides from './localesOverrides';
import ELocale from './locales';

function updateLocaleIfNeeded(locale: ELocale): void {
    if (locale === ELocale.RU) {
        moment.updateLocale(locale, localesOverrides[ELocale.RU]);
    }
}

export default function setDateLocale(locale: ELocale = ELocale.RU): void {
    updateLocaleIfNeeded(locale);

    moment.locale(locale);
}
