import {
    PAYMENT_TEST_CONTEXT,
    START_PAYMENT_TEST_CONTEXT,
    SUCCESS_PAYMENT_CONTEXT_PARAMS,
} from 'helpers/constants/testContext';
import {SECOND} from 'helpers/constants/dates';

import {IGetPaymentTestContextTokenParams} from 'helpers/project/common/api/types/PaymentTestContext';

import {TestOrdersApiClient} from 'helpers/project/common/api/TestOrdersApiClient';

export class PaymentTestContextHelper {
    private readonly browser: WebdriverIO.Browser;
    private readonly ordersApiClient: TestOrdersApiClient;

    constructor(browser: WebdriverIO.Browser) {
        this.browser = browser;

        this.ordersApiClient = new TestOrdersApiClient();
    }

    async setPaymentTestContext(
        requestParams: IGetPaymentTestContextTokenParams = SUCCESS_PAYMENT_CONTEXT_PARAMS,
    ): Promise<void> {
        const {token: paymentContextToken} =
            await this.ordersApiClient.getPaymentTestContextToken(
                requestParams,
            );

        await this.browser.setCookie({
            name: PAYMENT_TEST_CONTEXT,
            value: paymentContextToken,
        });
    }

    async setStartPaymentTestContext(
        requestParams: IGetPaymentTestContextTokenParams = SUCCESS_PAYMENT_CONTEXT_PARAMS,
    ): Promise<void> {
        const {token: paymentContextToken} =
            await this.ordersApiClient.getPaymentTestContextToken(
                requestParams,
            );

        await this.browser.setCookie({
            name: START_PAYMENT_TEST_CONTEXT,
            value: paymentContextToken,
        });
    }

    async clearPaymentTestContext(): Promise<void> {
        await this.browser.deleteCookie(PAYMENT_TEST_CONTEXT);
    }

    async clearStartPaymentTestContext(): Promise<void> {
        await this.browser.deleteCookie(START_PAYMENT_TEST_CONTEXT);
    }

    getProgressiveDelay(
        baseDelaySeconds: number,
        currentRetry: number,
    ): string {
        const timeout = Math.round(
            Math.min(90 * SECOND, baseDelaySeconds * 1.5 ** currentRetry),
        );

        return `PT${timeout}S`;
    }
}
