const fs = require('fs-extra');

class CreateFallenTestsReport {
    constructor({hermione, reportFile}) {
        this.hermione = hermione;
        this.reportFile = reportFile;
        this.fallenTests = [];
    }

    start() {
        this.initBindings();
    }

    initBindings() {
        this.hermione.on(
            this.hermione.events.INIT,
            this.handleHermioneInit.bind(this),
        );
        this.hermione.on(
            this.hermione.events.TEST_FAIL,
            this.handleHermioneTestFail.bind(this),
        );
        this.hermione.on(
            this.hermione.events.RUNNER_END,
            this.handleHermioneRunnerEnd.bind(this),
        );
    }

    /* Handlers */

    async handleHermioneInit() {
        return await this.clearReportFile();
    }

    async handleHermioneTestFail(fallenTest) {
        const {browserId} = fallenTest;
        const fullTitle = fallenTest.fullTitle();

        this.fallenTests.push({browserId, fullTitle});
    }

    async handleHermioneRunnerEnd() {
        return await this.writeFallenTestReport();
    }

    /* Actions */

    async clearReportFile() {
        try {
            await fs.remove(this.reportFile);
        } catch (e) {
            throw new Error(
                `Failed to clear ${this.reportFile}, plugin: 'CreateFallenTestsReport'`,
            );
        }
    }

    async writeFallenTestReport() {
        try {
            await fs.outputJson(this.reportFile, this.fallenTests);
        } catch (e) {
            throw new Error(
                `Failed to write ${this.reportFile}, plugin: 'CreateFallenTestsReport'`,
            );
        }
    }
}

module.exports = CreateFallenTestsReport;
