const {root, section, option} = require('gemini-configparser');

/* Constants */
const PLUGIN_ENV_PREFIX = 'hermione_create_fallen_tests_report';
const PLUGIN_CLI_PREFIX = '--hermione-create-fallen-tests-report-';

module.exports = options => {
    const {env, argv} = process;

    return root(
        section({
            enabled: option({
                defaultValue: false,
                parseEnv: JSON.parse,
                parseCli: JSON.parse,
                validate: value => {
                    if (typeof value !== 'boolean') {
                        throw new Error(
                            'Wrong type for "enabled" option, plugin: "CreateFallenTestsReport"',
                        );
                    }
                },
            }),
            reportFile: option({
                defaultValue: 'reports/fallenTestsReport.json',
                validate: value => {
                    if (typeof value !== 'string') {
                        throw new Error(
                            'Wrong type for "reportFile" option, plugin: "CreateFallenTestsReport"',
                        );
                    }
                },
            }),
        }),
        {envPrefix: PLUGIN_ENV_PREFIX, cliPrefix: PLUGIN_CLI_PREFIX},
    )({options, env, argv});
};
