const fs = require('fs-extra');

class FilterFallenTests {
    constructor({hermione, reportFile}) {
        this.hermione = hermione;
        this.reportFile = reportFile;
        this.filterTests = null;
    }

    start() {
        this.initBindings();
    }

    initBindings() {
        this.hermione.on(
            this.hermione.events.INIT,
            this.handleHermioneInit.bind(this),
        );
        this.hermione.on(
            this.hermione.events.AFTER_TESTS_READ,
            this.handleHermioneAfterTestsRead.bind(this),
        );
    }

    /* Handlers */

    async handleHermioneInit() {
        return await this.readReportFile();
    }

    handleHermioneAfterTestsRead(testCollection) {
        this.startFilterTests(testCollection);
    }

    /* Actions */

    async readReportFile() {
        try {
            this.filterTests = await fs.readJson(this.reportFile);
        } catch (e) {
            this.filterTests = null;
        }
    }

    startFilterTests(testCollection) {
        if (this.filterTests) {
            testCollection.disableAll();

            this.filterTests.forEach(({fullTitle, browserId}) => {
                testCollection.enableTest(fullTitle, browserId);
            });
        }
    }
}

module.exports = FilterFallenTests;
