const {root, section, option} = require('gemini-configparser');

/* Constants */
const PLUGIN_ENV_PREFIX = 'hermione_filter_fallen_tests';
const PLUGIN_CLI_PREFIX = '--hermione-filter-fallen-tests-';

module.exports = options => {
    const {env, argv} = process;

    return root(
        section({
            enabled: option({
                defaultValue: false,
                parseEnv: JSON.parse,
                parseCli: JSON.parse,
                validate: value => {
                    if (typeof value !== 'boolean') {
                        throw new Error(
                            'Wrong type for "enabled" option, plugin: "FilterFallenTests"',
                        );
                    }
                },
            }),
            reportFile: option({
                defaultValue: 'reports/fallenTestsReport.json',
                validate: value => {
                    if (typeof value !== 'string') {
                        throw new Error(
                            'Wrong type for "reportFile" option, plugin: "FilterFallenTests"',
                        );
                    }
                },
            }),
        }),
        {envPrefix: PLUGIN_ENV_PREFIX, cliPrefix: PLUGIN_CLI_PREFIX},
    )({options, env, argv});
};
