const {root, section, option} = require('gemini-configparser');

/* Constants */
const PLUGIN_ENV_PREFIX = 'hermione_skip_tests_by_report';
const PLUGIN_CLI_PREFIX = '--hermione-skip-tests-by-report-';

module.exports = options => {
    const {env, argv} = process;

    return root(
        section({
            enabled: option({
                defaultValue: false,
                parseEnv: JSON.parse,
                parseCli: JSON.parse,
                validate: value => {
                    if (typeof value !== 'boolean') {
                        throw new Error(
                            'Wrong type for "enabled" option, plugin: "SkipTestsByReport"',
                        );
                    }
                },
            }),
            reportFile: option({
                defaultValue: 'skipTestsReport.json',
                validate: value => {
                    if (typeof value !== 'string') {
                        throw new Error(
                            'Wrong type for "reportFile" option, plugin: "SkipTestsByReport"',
                        );
                    }
                },
            }),
        }),
        {envPrefix: PLUGIN_ENV_PREFIX, cliPrefix: PLUGIN_CLI_PREFIX},
    )({options, env, argv});
};
